#! /bin/bash
sampleID=$1
sampleID_normal=$2
tumorBam=$3
controlBam=$4
sampleDir=$5
# ref
ref=/data/fs09/wangzf/nanopore/ztf/HCC/ref/hg38_mainChr.fa
germResc=/data/fs08/wangzf/WGS_ztf/INFO/af-only-gnomad.hg38.vcf.gz
# files configure
sampleDir_gatk=${sampleDir}/GATK
sampleDir_mutect2=${sampleDir_gatk}/Mutect2
logfile=${sampleDir_mutect2}/${sampleID}_GATK.log
vcf_mutect2=${sampleDir_mutect2}/${sampleID}_Mutect2.vcf.gz
bam_mutect2=${sampleDir_mutect2}/${sampleID}_Mutect2.bam
vcf_mutect2_filter=${sampleDir_mutect2}/${sampleID}_Mutect2.filter.vcf.gz
# tools
gatk=/data/fs01/wangzf/nanopore/ref/gatk-4.1.2.0/gatk
# check bam index
tumorBam_bai=${tumorBam}.bai
controlBam_bai=${controlBam}.bai
# Mutect2
echo "$(date) 1. Mutect2 start: $sampleID" >> "$logfile"
${gatk} --java-options "-Xmx50g" Mutect2 -R "$ref" \
-I "$tumorBam" -I "$controlBam" \
-tumor "$sampleID" \
-normal "$sampleID_normal" \
--native-pair-hmm-threads 20 \
--germline-resource "$germResc" \
-O "$vcf_mutect2" \
-bamout "$bam_mutect2"
echo "$(date) 1. Mutect2 finish: $sampleID" >> "$logfile"
# FilterMutectCalls
echo "$(date) 2. FilterMutectCalls start: $sampleID" >> "$logfile"
${gatk} --java-options "-Xmx50g" FilterMutectCalls -R "$ref" \
-V "$vcf_mutect2" \
-O "$vcf_mutect2_filter"
echo "$(date) 2. FilterMutectCalls finish: $sampleID" >> "$logfile"
